var samplePageObj = {
  // 샘플 타이틀
  title: '멀티 레코드(쇼핑몰)',
  subtitle: '하나의 데이터를 여러행으로 나눠서 볼 수 있는 기능에 대한 예제입니다.',
  // 샘플 설명
  desc: '일반적인 데이터 그리드는 하나의 데이터가 하나의 행으로 보여지는데 멀티 레코드 기능은 하나의 데이터를 여러 행으로 표현해서 많은 데이터를 한 번에 제공할 수 있는 기능입니다.<br/>쇼핑몰에서 상품에 대한 정보를 여러개로 나눠서 표현하는 예제입니다.',

  // 객체 초기화 구문
  init: {
    Cfg: {
      SearchMode: 2,
      MultiRecord: 1,
      FitWidth: true
    },
    Cols: [
      // 첫번째 단위 데이터(DataRow) 행
      [
        {
          Header: '선택',
          Type: 'CheckBox',
          Name: 'CHK',
          Align: 'Center',
          MinWidth: 50,
          Width: 87
        },
        {
          Header: '이미지',
          Type: 'Img',
          Name: 'sProductImage',
          MinWidth: 100,
          Align: 'Center',
          RecordRowSpan: 2,
          Width: 156
        },
        {
          Header: '종류',
          Type: 'Text',
          Name: 'sCategory',
          MinWidth: 100,
          Align: 'Center',
          TextColor: '#AAAAAA',
          Width: 156
        },
        {
          Header: '특징',
          Type: 'Lines',
          Name: 'sSpec',
          MinWidth: 200,
          Align: 'Left',
          RecordRowSpan: 2,
          Wrap: 1,
          Width: 314
        },
        {
          Header: '가격',
          Type: 'Int',
          Name: 'sPrice',
          MinWidth: 80,
          Align: 'Right',
          RecordRowSpan: 2,
          Width: 126
        },
        {
          Header: '혜택',
          Type: 'Lines',
          Name: 'sBenefit',
          MinWidth: 90,
          Align: 'Center',
          Width: 141
        },
        {
          Header: '등록일',
          Type: 'Date',
          Name: 'sCdate',
          Format: 'yyyy/MM/dd',
          EditFormat: 'yyyyMMdd',
          DataFormat: 'yyyyMMdd',
          MinWidth: 80,
          Align: 'Center',
          Width: 126
        }
      ],
      // 두번째 단위 데이터(DataRow) 행
      [
        {
          Header: '순번',
          Name: 'SEQ',
          Align: 'Center'
        },
        { Header: '이미지' },
        {
          Header: '제품명',
          Type: 'Text',
          Name: 'sProductName',
          Align: 'Center',
          TextStyle: 4
        },
        { Header: '특징' },
        { Header: '가격' },
        {
          Header: '배송비',
          Type: 'Text',
          Name: 'sShipping',
          Align: 'Center'
        },
        {
          Header: '판매자',
          Type: 'Img',
          Name: 'sSeller',
          Align: 'Center'
        }
      ]
    ]
  },

  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '<div></div>',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '<span></span>',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 정적데이터
    });
  },

  // 버튼 클릭시 기능 로직
  action: function () {
  },

  // event구문
  event: {
  },

  // style 추가
  internalStyles: 'a{text-decoration:none;color:#4444FF;}',

  // data
  data: [
    {
      sProductImage: '|../assets/imgs/10/1.jpg|60|60|||',
      sCategory: '가전 > 디지털TV > LED TV',
      sSpec: 'LED TV / 106cm(42인치) / 에지형 / 풀HD / 60Hz 스캔 / CPI:120 / 1ms 응답 / USB(사진,음악,동영상) / DLNA(유선) / MHL / HDMI(2개) / USB(1개) / 40W소비전력 / 에너지효율:1등급 / 1년전기요금:14,000원 / 두께:7.9cm ',
      sPrice: 663000,
      sBenefit: '카드할인 12,000원\n적립 40,000원',
      sBenefitTextColor: '#DD4444',
      SBenefitTextSize: '11px',
      sCdate: '20131210',
      sProductName: 'LG전자 42LN5400',
      sShipping: '40,000',
      sShippingTextColor: '#229922',
      sSeller: '|../assets/imgs/10/22.gif||22|||'
    },
    {
      sProductImage: '|../assets/imgs/10/2.jpg|60|60|||',
      sCategory: '가전 > 디지털TV > LED TV',
      sSpec: 'LED TV / 80cm(32인치) / 에지형 / HD / 60Hz 스캔 / CPI:120 / 100만:1 명암비 / 1ms 응답 / 스포츠모드 / 힐링모드 / USB(사진,음악,동영상) / 타임머신 / MHL / HDMI(2개) / USB(1개) / 28W소비전력 / 에너지효율:1등급 / 1년전기요금:10,000원 / 엔젤윙스탠드 / 두께:5.65cm ',
      sPrice: 410000,
      sBenefit: '적립 20,000원',
      sBenefitTextColor: '#DD4444',
      SBenefitTextSize: '11px',
      sCdate: '20140320',
      sProductName: 'LG전자 32LB555B',
      sShipping: '무료 배송',
      sShippingTextColor: '#229922',
      sSeller: '|../assets/imgs/10/33.gif||22|||'
    },
    {
      sProductImage: '|../assets/imgs/10/3.jpg|60|60|||',
      sCategory: '가전 > 디지털TV > LED TV',
      sSpec: 'LED TV / 116cm(46인치) / 직하형 / 풀HD / CMR:480 / 3D하이퍼리얼엔진 / 3D영상(셔터) / 2D→3D변환 / 3D안경(2개) / USB(사진,음악,동영상) / HDMI(2개) / USB(1개) / 42W소비전력 / 에너지효율:1등급 / 1년전기요금:15,000원 / 쿼드디자인 / 두께:4.9cm',
      sPrice: 1020000,
      sBenefit: '무이자 적립 80,000원',
      sBenefitTextColor: '#DD4444',
      SBenefitTextSize: '11px',
      sCdate: '20140402',
      sProductName: '삼성전자 시리즈6 UN46F6100AF',
      sShipping: '25000',
      sShippingTextColor: '#229922',
      sSeller: '|../assets/imgs/10/44.gif||22|||'
    },
    {
      sProductImage: '|../assets/imgs/10/4.jpg|60|60|||',
      sCategory: '가전 > 디지털TV > LED TV(스마트)',
      sSpec: 'LED TV / 138cm(55인치) / 에지형 / 풀HD / 120Hz 스캔 / CPI:480 / 100만:1 명암비 / 시네마3D엔진 / 3D입체영상(FPR) / 2D→3D변환 / 듀얼플레이 / 3D안경(2개) / 스마트TV / 듀얼코어 / 인터넷 /  매직리모컨 / 무선랜(내장)  / USB(3개) / 67W소비전력 / 에너지효율:2등급 / 1년전기요금:23,000원 / 두께:3.6cm / 내장메모리:8GB / 구글TV 3.0',
      sPrice: 2095690,
      sBenefit: '카드할인 80,000원\n무이자 적립 80,000원',
      sBenefitTextColor: '#DD4444',
      SBenefitTextSize: '11px',
      sCdate: '20130816',
      sProductName: 'LG전자 55GA6400',
      sShipping: '무료배송',
      sShippingTextColor: '#229922',
      sSeller: '|../assets/imgs/10/55.gif||22|||'
    },
    {
      sProductImage: '|../assets/imgs/10/5.jpg|60|60|||',
      sCategory: '가전 > 디지털TV > LCD TV',
      sSpec: 'LED TV / 81cm(32인치) / 에지형 / 풀HD / 120Hz 스캔 / 500만:1 명암비 / 8ms 응답 / 450cd / USB(사진,음악,동영상) / MHL / HDMI(3개) / USB(2개) / 41W소비전력 / 하이글로시 / 두께:4.7cm',
      sPrice: 290000,
      sBenefit: '',
      sBenefitTextColor: '#DD4444',
      SBenefitTextSize: '11px',
      sCdate: '20140305',
      sProductName: '디지털존 DZONEI ZR320FHT 화이트',
      sShipping: '5000',
      sShippingTextColor: '#229922',
      sSeller: '|../assets/imgs/10/11.gif||22|||'
    },
    {
      sProductImage: '|../assets/imgs/10/6.jpg|60|60|||',
      sCategory: '가전 > 디지털TV > LED TV',
      sSpec: 'LED TV / 163cm(65인치) / 울트라HD / CPI:1560 / 시네마3D엔진 / UHD업스케일링 / HDMI2.0 / HEVC / 3D입체영상(FPR) / 2D→3D변환 / 3D사운드설정 / 듀얼플레이 / 3D안경(2개) / 웹OS / 스마트TV무선랜(내장) / 내장메모리:16GB / USB(사진,음악,동영상) / 타임머신 / DLNA(유,무선) / WiFi다이렉트 / LG클라우드 / 2ndTV / 미라캐스트 / 태그온 / MHL / 노트북연결(Wi-Di) / HDMI(4개) / USB(3개) / 141W소비전력 / 에너지효율:4등급 / 1년전기요금:49,000원 / 두께:7.5cm ',
      sPrice: 5949900,
      sBenefit: '카드할인 250,000원\n무이자 적립 120,000원',
      sBenefitTextColor: '#DD4444',
      SBenefitTextSize: '11px',
      sCdate: '20140305',
      sProductName: 'LG전자 65UB9800',
      sShipping: '무료배송',
      sShippingTextColor: '#229922',
      sSeller: '|../assets/imgs/10/66.gif||22|||'
    },
    {
      sProductImage: '|../assets/imgs/10/1.jpg|60|60|||',
      sCategory: '가전 > 디지털TV > LED TV',
      sSpec: 'LED TV / 106cm(42인치) / 에지형 / 풀HD / 60Hz 스캔 / CPI:120 / 1ms 응답 / USB(사진,음악,동영상) / DLNA(유선) / MHL / HDMI(2개) / USB(1개) / 40W소비전력 / 에너지효율:1등급 / 1년전기요금:14,000원 / 두께:7.9cm ',
      sPrice: 663000,
      sBenefit: '카드할인 12,000원\n적립 40,000원',
      sBenefitTextColor: '#DD4444',
      SBenefitTextSize: '11px',
      sCdate: '20131210',
      sProductName: 'LG전자 42LN5400',
      sShipping: '40,000',
      sShippingTextColor: '#229922',
      sSeller: '|../assets/imgs/10/22.gif||22|||'
    },
    {
      sProductImage: '|../assets/imgs/10/2.jpg|60|60|||',
      sCategory: '가전 > 디지털TV > LED TV',
      sSpec: 'LED TV / 80cm(32인치) / 에지형 / HD / 60Hz 스캔 / CPI:120 / 100만:1 명암비 / 1ms 응답 / 스포츠모드 / 힐링모드 / USB(사진,음악,동영상) / 타임머신 / MHL / HDMI(2개) / USB(1개) / 28W소비전력 / 에너지효율:1등급 / 1년전기요금:10,000원 / 엔젤윙스탠드 / 두께:5.65cm ',
      sPrice: 410000,
      sBenefit: '적립 20,000원',
      sBenefitTextColor: '#DD4444',
      SBenefitTextSize: '11px',
      sCdate: '20140320',
      sProductName: 'LG전자 32LB555B',
      sShipping: '무료 배송',
      sShippingTextColor: '#229922',
      sSeller: '|../assets/imgs/10/33.gif||22|||'
    }
  ]
};

var sampleBtn = function () {
  var args = Array.prototype.slice.call(arguments, 0);

  samplePageObj.action.apply(null, args);
};
